﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using GetCommand;
using DotNet.FrameWork.Data;
using System.Data;
using System.Data.SqlClient;
using HaTeam.Dd.Model;
using System.Text;
namespace HteamDd.Web.Web
{
    public partial class Dd_Attention_Mange : System.Web.UI.Page
    {
         string[] user=null;
         public string user_Mes = null;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Session["user_Message"] != null)
                {
                    user_Mes = Session["user_Message"].ToString();
                    user = Session["user_Message"].ToString().Split(',');
                    BindAttention();
                }
                else
                {
                    Response.Redirect("/Default.aspx");
                }
            }
        }
        /// <summary>
        /// 绑定关联用户
        /// </summary>
        private void BindAttention()
        {            
            this.Rpt_Attention.DataSource = GetAttentionByUserID(user[0]);//根据用户ID
            this.Rpt_Attention.DataBind();
        }
        /// <summary>
        /// 获得关注的个数
        /// </summary>
        /// <returns></returns>
        public int Count()
        {
            GetCount gc = new GetCount();
            return gc.BindCount(user[0]);
        }
        /// <summary>
        /// 获取与关注本用户的用户
        /// </summary>
        /// <param name="userid">本用户的id</param>
        /// <returns></returns>
        public List<HaTeam.Dd.Model.Dd_Attention> GetAttentionByUserID(string userid)
        {
            string sql = "select * from Dd_Attention where Attention_UerID=" + userid;
            try
            {
                SqlDataReader dr = SqlHelper.ExecuteReader(CommandType.Text, sql, null);
                List<HaTeam.Dd.Model.Dd_Attention> listdm = new List<HaTeam.Dd.Model.Dd_Attention>();
                while (dr.Read())
                {
                    HaTeam.Dd.Model.Dd_Attention dam = new HaTeam.Dd.Model.Dd_Attention();
                    
                    dam.Attented_By_user = Convert.ToInt32(dr["Attented_By_user"]);
                    dam.Attention_BlackList = Convert.ToInt32(dr["Attention_BlackList"]);
                    dam.Attention_Count = Convert.ToInt32(dr["Attention_Count"]);
                    dam.Attention_Datetime = Convert.ToDateTime(dr["Attention_Datetime"]);
                    dam.Attention_Delete = Convert.ToInt32(dr["Attention_Delete"]);
                    dam.Attention_Guid = dr["Attention_Guid"].ToString();
                    dam.Attention_ID = Convert.ToInt32(dr["Attention_ID"]);
                    dam.Attention_Lock = Convert.ToInt32(dr["Attention_Lock"]);
                    dam.Attention_Order = Convert.ToInt32(dr["Attention_Order"]);
                    dam.Attention_Remark = dr["Attention_Remark"].ToString();
                    dam.Attention_State = Convert.ToInt32(dr["Attention_State"]);
                    dam.Attention_UerID = Convert.ToInt32(dr["Attention_UerID"]);
                    dam.Attention_UpDatetime = Convert.ToDateTime(dr["Attention_UpDatetime"]);
                    dam.Attention_Verify = Convert.ToInt32(dr["Attention_Verify"]);

                    listdm.Add(dam);
                }
                return listdm;
            }
            catch
            {
                return null;
            }
        }
        /// <summary>
        /// 获取用户的博客名称
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public string UserName(string userid)
        {
            string sql = "select User_BlogName from Dd_User where User_ID=@UserID";
            string User_BlogName;
            try
            {
              User_BlogName=  SqlHelper.ExecuteScalar(CommandType.Text, sql, new SqlParameter("@UserID", userid)).ToString();
            }
            catch
            {
                User_BlogName = "";
            }
            return User_BlogName;
        }
        /// <summary>
        /// 绑定头像
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public string BindPicture(string userID)
        {
            string url = null;
            string user_image = "select User_HeadPhoto from Dd_User where User_ID=@ID";
            SqlParameter parm_image = new SqlParameter("@ID", Convert.ToInt32(userID));          
            object o = DbHelperSQL.GetSingle(user_image, parm_image);
            url = o == null ? "/images/avatar_64_64_$1095.png" : string2Json(o.ToString());
            return url;
        }


        public string string2Json(string s)
        {
            StringBuilder sb = new StringBuilder();

            char[] c = s.ToCharArray();
            for (int i = 0; i < c.Length; i++)
            {
                switch (c[i])
                {
                    case '\"':
                        sb.Append("\\\"");
                        break;
                    case '\\':
                        sb.Append("\\\\");
                        break;
                    case '/':
                        sb.Append("\\/");
                        break;
                    case '\b':
                        sb.Append("\\b");
                        break;
                    case '\f':
                        sb.Append("\\f");
                        break;
                    case '\n':
                        sb.Append("\\n");
                        break;
                    case '\r':
                        sb.Append("\\r");
                        break;
                    case '\t':
                        sb.Append("\\t");
                        break;
                    default:
                        sb.Append(c[i].ToString());
                        break;
                }
                StringBuilder show = sb;
            }
            return sb.ToString();
        }
    }
}